// Security_DemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Security_Demo.h"
#include "Security_DemoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

QRETURN on_video_decoder_file_callback( ULONG nChannelNumber, PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	//SC_DEBUG( "CH%02d on_video_decoder_file_callback", nChannelNumber + 1 );

	CSecurity_DemoDlg * pMainDlg = (CSecurity_DemoDlg *)(pUserData);

	return QCAP_RT_OK;
}

QRETURN on_audio_decoder_file_callback( ULONG nChannelNumber, PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	//SC_DEBUG( "CH%02d on_audio_decoder_file_callback", nChannelNumber + 1 );

	CSecurity_DemoDlg * pMainDlg = (CSecurity_DemoDlg *)(pUserData);

	return QCAP_RT_OK;
}

QRETURN on_snapshot_done_callback( ULONG nChannelNumber, PVOID pFile, CHAR * pszFilePathName, PVOID pUserData )
{
	//SC_DEBUG( "CH%02d on_snapshot_done_callback( %s )", nChannelNumber + 1, pszFilePathName );

	return QCAP_RT_OK;
}

QRETURN on_video_decoder_file_callback_CH01( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_decoder_file_callback( 0x00000000, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_video_decoder_file_callback_CH02( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_decoder_file_callback( 0x00000001, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_video_decoder_file_callback_CH03( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_decoder_file_callback( 0x00000002, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_video_decoder_file_callback_CH04( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_decoder_file_callback( 0x00000003, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_video_decoder_file_callback_CH05( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_decoder_file_callback( 0x00000004, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_video_decoder_file_callback_CH06( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_decoder_file_callback( 0x00000005, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_video_decoder_file_callback_CH07( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_decoder_file_callback( 0x00000006, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_video_decoder_file_callback_CH08( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_decoder_file_callback( 0x00000007, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_video_decoder_file_callback_CH09( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_decoder_file_callback( 0x00000008, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }

QRETURN on_audio_decoder_file_callback_CH01( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_decoder_file_callback( 0x00000000, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_audio_decoder_file_callback_CH02( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_decoder_file_callback( 0x00000001, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_audio_decoder_file_callback_CH03( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_decoder_file_callback( 0x00000002, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_audio_decoder_file_callback_CH04( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_decoder_file_callback( 0x00000003, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_audio_decoder_file_callback_CH05( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_decoder_file_callback( 0x00000004, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_audio_decoder_file_callback_CH06( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_decoder_file_callback( 0x00000005, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_audio_decoder_file_callback_CH07( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_decoder_file_callback( 0x00000006, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_audio_decoder_file_callback_CH08( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_decoder_file_callback( 0x00000007, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_audio_decoder_file_callback_CH09( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_decoder_file_callback( 0x00000008, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }

QRETURN on_snapshot_done_callback_CH01( PVOID pFile, CHAR * pszFilePathName, PVOID pUserData ) { return on_snapshot_done_callback( 0x00000001, pFile, pszFilePathName, pUserData ); }
QRETURN on_snapshot_done_callback_CH02( PVOID pFile, CHAR * pszFilePathName, PVOID pUserData ) { return on_snapshot_done_callback( 0x00000002, pFile, pszFilePathName, pUserData ); }
QRETURN on_snapshot_done_callback_CH03( PVOID pFile, CHAR * pszFilePathName, PVOID pUserData ) { return on_snapshot_done_callback( 0x00000003, pFile, pszFilePathName, pUserData ); }
QRETURN on_snapshot_done_callback_CH04( PVOID pFile, CHAR * pszFilePathName, PVOID pUserData ) { return on_snapshot_done_callback( 0x00000004, pFile, pszFilePathName, pUserData ); }
QRETURN on_snapshot_done_callback_CH05( PVOID pFile, CHAR * pszFilePathName, PVOID pUserData ) { return on_snapshot_done_callback( 0x00000005, pFile, pszFilePathName, pUserData ); }
QRETURN on_snapshot_done_callback_CH06( PVOID pFile, CHAR * pszFilePathName, PVOID pUserData ) { return on_snapshot_done_callback( 0x00000006, pFile, pszFilePathName, pUserData ); }
QRETURN on_snapshot_done_callback_CH07( PVOID pFile, CHAR * pszFilePathName, PVOID pUserData ) { return on_snapshot_done_callback( 0x00000007, pFile, pszFilePathName, pUserData ); }
QRETURN on_snapshot_done_callback_CH08( PVOID pFile, CHAR * pszFilePathName, PVOID pUserData ) { return on_snapshot_done_callback( 0x00000008, pFile, pszFilePathName, pUserData ); }
QRETURN on_snapshot_done_callback_CH09( PVOID pFile, CHAR * pszFilePathName, PVOID pUserData ) { return on_snapshot_done_callback( 0x00000009, pFile, pszFilePathName, pUserData ); }

PF_VIDEO_DECODER_FILE_CALLBACK g_on_video_decoder_file_callback[ MAX_NUM_CHANNELS ] = 
{
	on_video_decoder_file_callback_CH01, on_video_decoder_file_callback_CH02, 
	on_video_decoder_file_callback_CH03, on_video_decoder_file_callback_CH04,
	on_video_decoder_file_callback_CH05, on_video_decoder_file_callback_CH06,
	on_video_decoder_file_callback_CH07, on_video_decoder_file_callback_CH08,
	on_video_decoder_file_callback_CH09
};

PF_AUDIO_DECODER_FILE_CALLBACK g_on_audio_decoder_file_callback[ MAX_NUM_CHANNELS ] = 
{
	on_audio_decoder_file_callback_CH01, on_audio_decoder_file_callback_CH02, 
	on_audio_decoder_file_callback_CH03, on_audio_decoder_file_callback_CH04,
	on_audio_decoder_file_callback_CH05, on_audio_decoder_file_callback_CH06,
	on_audio_decoder_file_callback_CH07, on_audio_decoder_file_callback_CH08,
	on_audio_decoder_file_callback_CH09
};

PF_SNAPSHOT_DONE_CALLBACK g_on_snapshot_done_callback[ MAX_NUM_CHANNELS ] = 
{
	on_snapshot_done_callback_CH01, on_snapshot_done_callback_CH02, 
	on_snapshot_done_callback_CH03, on_snapshot_done_callback_CH04,
	on_snapshot_done_callback_CH05, on_snapshot_done_callback_CH06,
	on_snapshot_done_callback_CH07, on_snapshot_done_callback_CH08,
	on_snapshot_done_callback_CH09
};

/////////////////////////////////////////////////////////////////////////////
// CSecurity_DemoDlg dialog

CSecurity_DemoDlg::CSecurity_DemoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSecurity_DemoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSecurity_DemoDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);		

	ULONG i = 0;

	for ( i = 0 ; i < MAX_NUM_CHANNELS ; i++ )
	{
		m_nRecordCout[ i ]		= 0;

		m_pScfFile[ i ]			= NULL;
	}
}

void CSecurity_DemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSecurity_DemoDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSecurity_DemoDlg, CDialog)
	//{{AFX_MSG_MAP(CSecurity_DemoDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_ERASEBKGND()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSecurity_DemoDlg message handlers

BOOL CSecurity_DemoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here	

	UINT i = 0;
	
	m_pViewManager = new MyViewManager;		

	// CREATE CHANNEL WINDOW
	// 
	CString strWinName;

	for ( i = 0 ; i < 64 ; i++ )
	{
		strWinName.Format( "MyChannelWindow%02d", i + 1 );

		m_oVideoWnd[ i ].m_nWndID = i;		

		m_oVideoWnd[ i ].Create( NULL, strWinName,  WS_CHILD | WS_VISIBLE | WS_BORDER, CRect(0, 0, 0, 0), this, i, NULL );				

		m_oVideoWnd[ i ].m_pParentDlg = this;

		m_oVideoWnd[ i ].ShowWindow( FALSE );
	}
	
	m_pViewManager->SetVideoWnds(LAYOUT01, m_oVideoWnd, 1);

	m_pViewManager->SetVideoWnds(LAYOUT04, m_oVideoWnd, 4);

	m_pViewManager->SetVideoWnds(LAYOUT09, m_oVideoWnd, 9);

	m_pViewManager->SetVideoWnds(LAYOUT16, m_oVideoWnd, 16);

	m_pViewManager->SetVideoWnds(LAYOUT36, m_oVideoWnd, 36);

	m_pViewManager->SetVideoWnds(LAYOUT64, m_oVideoWnd, 64);

	RECT rect;

	int nXResolution = GetSystemMetrics( SM_CXSCREEN );

	int nYResolution = GetSystemMetrics( SM_CYSCREEN );

	rect.left = 0; 
		
	rect.top = 0; 
		
	rect.right = 960; 
		
	rect.bottom = 540;	

	MoveWindow( 0, 0, 960, 540 );

	m_pViewManager->SetLayoutRect(rect);
	
	m_pViewManager->Activate(LAYOUT09, TRUE);

	SetWindowText( "Yuan's QCAP Demo Software" );

	CenterWindow( GetDesktopWindow() );

	ShowWindow( FALSE );

	m_ShowInfoDlg.m_pParentDlg = this;

	m_ShowInfoDlg.Create( IDD_SHOW_INFO );	

	m_ShowInfoDlg.ShowWindow( SW_SHOW );

	CString strTitle = "Yuan's QCAP Demo Software - SCF RECORD PLAYBACK ";

	m_ShowInfoDlg.SetWindowText( strTitle );

	QCAP_SET_SYSTEM_CONFIGURATION( TRUE, TRUE, TRUE, TRUE, TRUE, 3000, TRUE );		

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSecurity_DemoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

BOOL CSecurity_DemoDlg::OnEraseBkgnd(CDC* pDC) 
{
	return TRUE;

	return CWnd::OnEraseBkgnd(pDC);
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSecurity_DemoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BOOL CSecurity_DemoDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class

	if(pMsg->message == WM_KEYDOWN)
	{		
		if (pMsg->wParam == VK_ESCAPE)
		{
			SendMessage( WM_CLOSE, 0, 0 );

			return FALSE;
		}
	}
	
	return CDialog::PreTranslateMessage(pMsg);
}

void CSecurity_DemoDlg::GetFileInfoList( ULONG nCH, double dStartSearchSystemTime, double dStopSearchSystemTime )
{	
	if ( m_pScfFile[ nCH ] != NULL ) { QCAP_DESTROY_FILE( m_pScfFile[ nCH ] );	m_pScfFile[ nCH ] = NULL; }	

	ULONG nVideoEncoderFormat = 0;

	ULONG nAudioEncoderFormat = 0;

	ULONG nVideoWidth = 0, nVideoHeight = 0;	
	
	double dVideoFrameRate = 0.0;
	
	ULONG nAudioChannels = 0;
	
	ULONG nAudioBitsPerSample = 0;
	
	ULONG nAudioSampleFrequency = 0;

	double dFileStartTime = 0.0;
	
	double dFileStopTime = 0.0;

	double dVideoStartTime = 0.0;

	double dVideoStopTime = 0.0;

	double dTotalDurationTimes = 0.0;

	ULONG nTotalVideoFrames = 0;

	ULONG nTotalAudioFrames = 0;	

	ULONG nTotalMedatadaFrames = 0;	

	MY_SCF_FILE_INFO  dsFileInfo;

	QRESULT returns = QCAP_RS_SUCCESSFUL;
	
	m_vs_file_info[ nCH ].clear();

	m_nRecordCout[ nCH ] = 0;	

	m_ShowInfoDlg.m_dFileTotalDuationTimes[ nCH ] = 0;
	
	m_ShowInfoDlg.m_nTotalVideoFrames[ nCH ] = 0;

	m_ShowInfoDlg.m_nTotalAudioFrames[ nCH ] = 0;
	
	while( returns == QCAP_RS_SUCCESSFUL )
	{
		returns = QCAP_SCF_FILE_ENUMERATION( nCH, dStartSearchSystemTime, dStopSearchSystemTime, NULL, NULL, &dFileStartTime, &dFileStopTime, &dVideoStartTime, &dVideoStopTime, NULL, NULL, 
		
												&nVideoEncoderFormat, &nVideoWidth, &nVideoHeight, &dVideoFrameRate, 
												
												&nAudioEncoderFormat, &nAudioChannels, &nAudioBitsPerSample, &nAudioSampleFrequency, 
		
												&dTotalDurationTimes, &nTotalVideoFrames, &nTotalAudioFrames, &nTotalMedatadaFrames, TRUE );		

		if ( returns != QCAP_RS_SUCCESSFUL ) { break; }
	
		dsFileInfo.dFileStartTime			= dFileStartTime;
		dsFileInfo.dFileStopTime			= dFileStopTime;
		dsFileInfo.dVideoStartTime			= dVideoStartTime;
		dsFileInfo.dVideoStopTime			= dVideoStopTime;
		dsFileInfo.m_nVideoEncoderFormat	= nVideoEncoderFormat;
		dsFileInfo.m_nAudioEncoderFormat	= nAudioEncoderFormat;
		dsFileInfo.m_nVideoWidth			= nVideoWidth;
		dsFileInfo.m_nVideoHeight			= nVideoHeight;
		dsFileInfo.m_dVideoFrameRate		= dVideoFrameRate;
		dsFileInfo.m_nAudioChannels			= nAudioChannels;
		dsFileInfo.m_nAudioBitsPerSample	= nAudioBitsPerSample;
		dsFileInfo.m_nAudioSampleFrequency  = nAudioSampleFrequency;
		dsFileInfo.m_dTotalDurationTimes	= dTotalDurationTimes;
		dsFileInfo.m_dTotalVideoFrames		= nTotalVideoFrames;
		dsFileInfo.m_dTotalAudioFrames		= nTotalAudioFrames;

		m_vs_file_info[ nCH ].push_back( dsFileInfo );

		m_nRecordCout[ nCH ]++;

		m_ShowInfoDlg.m_dFileTotalDuationTimes[ nCH ] += dTotalDurationTimes;

		m_ShowInfoDlg.m_nTotalVideoFrames[ nCH ] += nTotalVideoFrames;

		m_ShowInfoDlg.m_nTotalAudioFrames[ nCH ] += nTotalAudioFrames;

		if ( nCH == 0 ) { m_ShowInfoDlg.m_progTimeBar1.SetRange32( 0, (int)m_ShowInfoDlg.m_dFileTotalDuationTimes[ nCH ] ); }
		if ( nCH == 1 ) { m_ShowInfoDlg.m_progTimeBar2.SetRange32( 0, (int)m_ShowInfoDlg.m_dFileTotalDuationTimes[ nCH ] ); }
		if ( nCH == 2 ) { m_ShowInfoDlg.m_progTimeBar3.SetRange32( 0, (int)m_ShowInfoDlg.m_dFileTotalDuationTimes[ nCH ] ); }
		if ( nCH == 3 ) { m_ShowInfoDlg.m_progTimeBar4.SetRange32( 0, (int)m_ShowInfoDlg.m_dFileTotalDuationTimes[ nCH ] ); }
		if ( nCH == 4 ) { m_ShowInfoDlg.m_progTimeBar5.SetRange32( 0, (int)m_ShowInfoDlg.m_dFileTotalDuationTimes[ nCH ] ); }
		if ( nCH == 5 ) { m_ShowInfoDlg.m_progTimeBar6.SetRange32( 0, (int)m_ShowInfoDlg.m_dFileTotalDuationTimes[ nCH ] ); }
		if ( nCH == 6 ) { m_ShowInfoDlg.m_progTimeBar7.SetRange32( 0, (int)m_ShowInfoDlg.m_dFileTotalDuationTimes[ nCH ] ); }
		if ( nCH == 7 ) { m_ShowInfoDlg.m_progTimeBar8.SetRange32( 0, (int)m_ShowInfoDlg.m_dFileTotalDuationTimes[ nCH ] ); }
		if ( nCH == 8 ) { m_ShowInfoDlg.m_progTimeBar9.SetRange32( 0, (int)m_ShowInfoDlg.m_dFileTotalDuationTimes[ nCH ] ); }
	}

	m_ShowInfoDlg.m_nTotalSection[ nCH ] = m_nRecordCout[ nCH ];

	m_ShowInfoDlg.m_nCurSection[ nCH ] = 0;	
}

void CSecurity_DemoDlg::OpenScfFile( ULONG nCH )
{		
	if ( m_nRecordCout[ nCH ] > 0 )
	{
		QRESULT returns = QCAP_RS_SUCCESSFUL;
		
		returns = QCAP_OPEN_SCF_FILE( nCH, &m_pScfFile[ nCH ], QCAP_DECODER_TYPE_SOFTWARE, m_oVideoWnd[ nCH ], TRUE, TRUE, 0, 0 );
	
		returns = QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK( m_pScfFile[ nCH ], g_on_video_decoder_file_callback[ nCH ], this );

		returns = QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK( m_pScfFile[ nCH ], g_on_audio_decoder_file_callback[ nCH ], this );

		returns = QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK( m_pScfFile[ nCH ],  g_on_snapshot_done_callback[ nCH ], this );
	
#ifdef GLOBAL_TIMER

		QCAP_SET_SCF_FILE_TIMER( nCH, TRUE );
#else
		
		QCAP_PAUSE_FILE( m_pScfFile[ nCH ] );
#endif	
	}
}

void CSecurity_DemoDlg::SetScfFileGlobalTimer( ULONG nCH )
{
	QCAP_SET_SCF_FILE_TIMER( nCH, TRUE );
}

CString CSecurity_DemoDlg::GetWorkingPath(CString strWorkFile)
{
	TCHAR szCurPath[MAX_PATH] = {0};

	GetModuleFileName(NULL, szCurPath, MAX_PATH);

	CString strCurPath = szCurPath;

	strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

	strCurPath += strWorkFile;

	return strCurPath;
}

BOOL CSecurity_DemoDlg::IsFileExists(const TCHAR* pFile)
{
	WIN32_FIND_DATA FindFileData;

	HANDLE hFind = INVALID_HANDLE_VALUE;

	hFind = FindFirstFile(pFile, &FindFileData);

	if (hFind == INVALID_HANDLE_VALUE) 
	{	
		return FALSE;
	} 
	else 
	{
		FindClose(hFind);

		return TRUE;
	}
}

void CSecurity_DemoDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default	
}

void CSecurity_DemoDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	KillTimer( 0x00000000 );

	for ( ULONG i = 0 ; i < MAX_NUM_CHANNELS ; i++ )
	{
		if ( m_pScfFile[ i ] != NULL ) { QCAP_DESTROY_FILE( m_pScfFile[ i ] );	m_pScfFile[ i ] = NULL; }
	}

	if (m_pViewManager) { delete m_pViewManager;  m_pViewManager = NULL; }
}
